// Minimalistischer Host fr das Reinladen eines DelphiAutoServer-Objekts
// in die running object table (ROT). Dieses Objekt ist aus der Sicht
// von DelphiComAutoServTest.exe dann ein out-of-process-Server.

unit ComServHostU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DelphiAutoServ_TLB, StdCtrls, ActiveX;

type
  TComServHostForm = class(TForm)
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  public
    CT:  IDelphiAutoServer;
    ROTCookie: Integer;
  end;

var
  ComServHostForm: TComServHostForm;

implementation

{$R *.dfm}

procedure TComServHostForm.FormCreate(Sender: TObject);
begin
  // Damit die Suche von DelphiComAutoServTest nicht im Designer
  // von Delphi hngenbleibt - manuelle nderung es Titels
  Caption := Caption + ' - Active';

  CT := CoDelphiAutoServer.Create;
  RegisterActiveObject(CT, CLASS_DelphiAutoServer, ACTIVEOBJECT_WEAK, ROTCookie);
  CoLockObjectExternal(CT, true, true);
end;

procedure TComServHostForm.FormDestroy(Sender: TObject);
begin
  CoLockObjectExternal(CT, false, true);
  RevokeActiveObject(ROTCookie, nil);
  CoDisconnectObject(CT, 0);
end;

end.
